<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;


class CustomerController extends Controller
{
   
public function index()
{
    $customers = DB::table('customers')
        ->orderByDesc('id')
        ->get();

    return view('admin.customers.index', compact('customers'));
}

public function create()
{
    return view('admin.customers.create');
}


public function store(Request $request)
{
    $request->validate([
        'name'     => 'required|string',
        'email'    => 'required|email|unique:customers,email',
        'password' => 'required|min:6',
        'phone'    => 'nullable|string',
        'address'  => 'nullable|string',
    ]);

    DB::table('customers')->insert([
        'name'       => $request->name,
        'email'      => $request->email,
        'password'   => Hash::make($request->password), // 🔥 HASH DI SINI
        'phone'      => $request->phone,
        'address'    => $request->address,
        'created_at' => now(),
        'updated_at' => now(),
    ]);

    return redirect()
        ->route('admin.customers.index')
        ->with('success', 'Customer berhasil ditambahkan');
}


public function edit($id)
{
    $customer = DB::table('customers')
        ->where('id', $id)
        ->first();

    return view('admin.customers.edit', compact('customer'));
}


public function update(Request $request, $id)
{
    $request->validate([
        'name'     => 'required|string',
        'email'    => 'required|email',
        'password' => 'nullable|min:6',   
        'phone'    => 'nullable|string',
        'address'  => 'nullable|string',
    ]);

    
    $data = [
        'name'       => $request->name,
        'email'      => $request->email,
        'phone'      => $request->phone,
        'address'    => $request->address,
        'updated_at' => now(),
    ];

    
    if ($request->filled('password')) {
        $data['password'] = Hash::make($request->password);
    }

    DB::table('customers')
        ->where('id', $id)
        ->update($data);

    return redirect()
        ->route('admin.customers.index')
        ->with('success', 'Customer berhasil diperbarui');
}


public function destroy($id)
{
    DB::table('customers')
        ->where('id', $id)
        ->delete();

    return redirect()
        ->route('admin.customers.index')
        ->with('success', 'Customer berhasil dihapus');
}

}

