<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Spatie\LaravelPdf\Facades\Pdf;

class OrderController extends Controller
{
    
    public function index()
    {
        $orders = DB::table('orders')
            ->orderByDesc('id')
            ->get();

        return view('admin.orders.index', compact('orders'));
    }

    
    public function create()
    {
        return view('admin.orders.create');
    }

        public function store(Request $request)
    {
        $request->validate([
            'product_id'        => 'required|integer',
            'customer_name'    => 'required|string',
            'customer_address' => 'required|string',
            'customer_phone'   => 'required|string',
            'size'             => 'required|string',
            'quantity'         => 'required|integer',
            'total_price'      => 'required|numeric',
            'payment_method'   => 'required|string',
            'status'           => 'required|string',
            'order_date'       => 'required',
        ]);

        DB::table('orders')->insert([
            'product_id'        => $request->product_id,
            'customer_name'    => $request->customer_name,
            'customer_address' => $request->customer_address,
            'customer_phone'   => $request->customer_phone,
            'size'             => $request->size,
            'quantity'         => $request->quantity,
            'total_price'      => $request->total_price,
            'payment_method'   => $request->payment_method,
            'status'           => $request->status,
            'order_date'       => $request->order_date,
            'created_at'       => now(),
            'updated_at'       => now(),
        ]);

        return redirect()
            ->route('admin.orders.index')
            ->with('success', 'Order berhasil ditambahkan');
    }

    
    public function edit($id)
    {
        $order = DB::table('orders')
            ->where('id', $id)
            ->first();

        return view('admin.orders.edit', compact('order'));
    }

    
    public function update(Request $request, $id)
    {
        $request->validate([
            'product_id'        => 'required|integer',
            'customer_name'    => 'required|string',
            'customer_address' => 'required|string',
            'customer_phone'   => 'required|string',
            'size'             => 'required|string',
            'quantity'         => 'required|integer',
            'total_price'      => 'required|numeric',
            'payment_method'   => 'required|string',
            'status'           => 'required|string',
            'order_date'       => 'required',
        ]);

        DB::table('orders')
            ->where('id', $id)
            ->update([
                'product_id'        => $request->product_id,
                'customer_name'    => $request->customer_name,
                'customer_address' => $request->customer_address,
                'customer_phone'   => $request->customer_phone,
                'size'             => $request->size,
                'quantity'         => $request->quantity,
                'total_price'      => $request->total_price,
                'payment_method'   => $request->payment_method,
                'status'           => $request->status,
                'order_date'       => $request->order_date,
                'updated_at'       => now(),
            ]);

        return redirect()
            ->route('admin.orders.index')
            ->with('success', 'Order berhasil diperbarui');
    }

    
    public function destroy($id)
    {
        DB::table('orders')
            ->where('id', $id)
            ->delete();

        return redirect()
            ->route('admin.orders.index')
            ->with('success', 'Order berhasil dihapus');
    }


    public function struk($id)
{
    $order = DB::table('orders')
        ->where('id', $id)
        ->first();

    if (!$order) {
        abort(404);
    }

    return Pdf::view('admin.orders.struk', compact('order'))
        ->format('A5')
        ->name('struk-order-'.$order->id.'.pdf')
        ->download();
}
}

