<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class OrderCustomerController extends Controller
{

   public function history()
{
    
    if (!Auth::check()) {
        return redirect('/login')->with('error', 'Silakan login dulu');
    }

    $orders = DB::table('orders')
        ->where('customer_id', Auth::id())   
        ->orderByDesc('id')
        ->get();

    return view('orders.history', compact('orders'));
}



    
    public function create($product_id)
    {
        $product = DB::table('products')
            ->where('id', $product_id)
            ->first();

        if (!$product) {
            abort(404);
        }

        return view('orders.create', compact('product'));
    }

    
    public function store(Request $request)
    {
        $request->validate([
            'product_id'        => 'required|integer',
            'customer_name'    => 'required|string',
            'customer_address' => 'required|string',
            'customer_phone'   => 'required|string',
            'size'             => 'required|string',
            'quantity'         => 'required|integer|min:1',
        ]);

        
        $product = DB::table('products')
            ->where('id', $request->product_id)
            ->first();

        if (!$product) {
            return back()->with('error', 'Produk tidak ditemukan');
        }

        $total = $product->price * $request->quantity;

        DB::table('orders')->insert([
        'customer_id'       => Auth::id(),   
        'product_id'        => $request->product_id,
        'customer_name'    => $request->customer_name,
        'customer_address' => $request->customer_address,
        'customer_phone'   => $request->customer_phone,
        'size'             => $request->size,
        'quantity'         => $request->quantity,
        'total_price'      => $total,
        'payment_method'   => 'COD',
        'status'           => 'pending',
        'order_date'       => now(),
        'created_at'       => now(),
        'updated_at'       => now(),
    ]);


       return redirect()
    ->route('orders.create', $request->product_id)
    ->with('success', 'Pesanan berhasil dibuat, silakan tunggu konfirmasi admin 🙏');

    }
}
