@extends('admin.layouts.app')

@section('content')
<div class="bg-white rounded-xl shadow p-6">

    <h1 class="text-2xl font-black mb-6">Manajemen Admin</h1>

    <a href="{{ route('admin.admins.create') }}"
       class="mb-4 inline-block px-4 py-2 bg-green-600 text-white rounded font-bold">
        + Tambah Admin
    </a>

    <table class="w-full border">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3">No</th>
                <th>Nama</th>
                <th>Email</th>
                <th width="160">Aksi</th>
            </tr>
        </thead>

        <tbody>
            @foreach ($admins as $a)
            <tr class="border-t">
                <td class="p-3">{{ $loop->iteration }}</td>
                <td>{{ $a->name }}</td>
                <td>{{ $a->email }}</td>
                <td class="flex gap-2 p-3">

                    <a href="{{ route('admin.admins.edit', $a->id) }}"
                       class="px-3 py-1 bg-yellow-500 text-white rounded font-bold">
                        Edit
                    </a>

                    <form action="{{ route('admin.admins.destroy', $a->id) }}"
                          method="POST"
                          onsubmit="return confirm('Hapus admin ini?')">
                        @csrf
                        @method('DELETE')

                        <button class="px-3 py-1 bg-red-600 text-white rounded font-bold">
                            Hapus
                        </button>
                    </form>

                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

</div>
@endsection
