@extends('admin.layouts.app')

@section('content')
<div class="bg-white rounded-xl shadow p-6">

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-black">Manajemen Customer</h1>

        <a href="{{ route('admin.customers.create') }}"
           class="px-4 py-2 bg-green-600 text-white rounded font-bold">
            + Tambah Customer
        </a>
    </div>

    <table class="w-full border">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3">Nama</th>
                <th>Email</th>
                <th>Phone</th>
                <th width="160">Aksi</th>
            </tr>
        </thead>

        <tbody>
            @foreach($customers as $customer)
            <tr class="border-t">
                <td class="p-3">{{ $customer->name }}</td>
                <td>{{ $customer->email }}</td>
                <td>{{ $customer->phone }}</td>
                <td class="flex gap-2 p-3">

                    <a href="{{ route('admin.customers.edit', $customer->id) }}"
                       class="px-3 py-1 bg-yellow-500 text-white rounded font-bold">
                        Edit
                    </a>

                    <form action="{{ route('admin.customers.destroy', $customer->id) }}"
                          method="POST"
                          onsubmit="return confirm('Hapus customer ini?')">
                        @csrf
                        @method('DELETE')

                        <button class="px-3 py-1 bg-red-600 text-white rounded font-bold">
                            Hapus
                        </button>
                    </form>

                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

</div>
@endsection
