<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Wayah Pesa Collection</title>
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;600;700;800&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        maroon: {
                            50: '#fff1f2',
                            800: '#800000',
                            900: '#660000',
                            950: '#450a0a',
                        }
                    },
                    fontFamily: { sans: ['Plus Jakarta Sans', 'sans-serif'] }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-100 font-sans min-h-screen flex items-center justify-center p-4">

    
    @if(session('success'))
    <script>
        Swal.fire({
            icon: 'success',
            title: 'Berhasil',
            text: "{{ session('success') }}",
            confirmButtonColor: '#800000',
        });
    </script>
    @endif

    
    @if($errors->any())
    <script>
        Swal.fire({
            icon: 'error',
            title: 'Login Gagal',
            text: 'Email atau password salah!',
            confirmButtonColor: '#800000',
        });
    </script>
    @endif

    <div class="max-w-md w-full">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-black text-maroon-800 tracking-tighter italic">
                WAYAH<span class="text-gray-400">PESA</span>
            </h1>
            <p class="text-gray-500 text-sm font-semibold mt-2 uppercase tracking-widest">Panel Kendali Toko</p>
        </div>

        <div class="bg-white rounded-[2rem] shadow-2xl shadow-maroon-900/10 overflow-hidden border border-gray-100">
            <div class="p-10">
                <div class="mb-8">
                    <h2 class="text-2xl font-extrabold text-gray-900">Selamat Datang</h2>
                    <p class="text-gray-400 text-sm mt-1">Silahkan masuk ke akun admin Anda.</p>
                </div>

                <form method="POST" action="/admin/login" class="space-y-6">
                    @csrf
                    
                    <div class="space-y-2">
                        <label class="text-xs font-black text-maroon-800 uppercase tracking-widest ml-1">Email Dashboard</label>
                        <div class="relative">
                            <input type="email" name="email" placeholder="admin@maroon.com" required
                                class="w-full px-6 py-4 rounded-2xl bg-gray-50 border-2 border-transparent focus:border-maroon-800 focus:bg-white outline-none transition-all font-semibold text-gray-700">
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label class="text-xs font-black text-maroon-800 uppercase tracking-widest ml-1">Password</label>
                        <input type="password" name="password" placeholder="••••••••" required
                            class="w-full px-6 py-4 rounded-2xl bg-gray-50 border-2 border-transparent focus:border-maroon-800 focus:bg-white outline-none transition-all font-semibold text-gray-700">
                    </div>

                    <div class="pt-4">
                        <button type="submit" 
                            class="w-full bg-maroon-800 hover:bg-maroon-950 text-white py-4 rounded-2xl font-black uppercase tracking-[0.2em] transition-all shadow-lg shadow-maroon-200 active:scale-[0.98] flex items-center justify-center gap-3">
                            Masuk Sekarang
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1" />
                            </svg>
                        </button>
                    </div>
                </form>
            </div>

            <div class="bg-gray-50 p-6 border-t border-gray-100 text-center">
                <a href="/" class="text-xs font-bold text-gray-400 hover:text-maroon-800 transition-colors uppercase tracking-widest">
                    ← Kembali ke Toko
                </a>
            </div>
        </div>

        <p class="text-center text-gray-400 text-[10px] mt-8 font-bold uppercase tracking-widest">
            &copy; 2026 Maroon Collection Admin System
        </p>
    </div>

</body>
</html>