@extends('admin.layouts.app')

@section('content')
<div class="bg-white rounded-xl shadow p-6 max-w-xl">

    <h1 class="text-2xl font-black mb-6">Edit Order</h1>

    <form action="{{ route('admin.orders.update', $order->id) }}" method="POST">
        @csrf
        @method('PUT')

        
        <input type="hidden" name="product_id" value="{{ $order->product_id }}">

        
        <input type="hidden" name="order_date" value="{{ $order->order_date }}">

        <input type="text" name="customer_name"
               value="{{ $order->customer_name }}"
               class="w-full border p-2 mb-3 rounded" required>

        <textarea name="customer_address"
                  class="w-full border p-2 mb-3 rounded" required>{{ $order->customer_address }}</textarea>

        <input type="text" name="customer_phone"
               value="{{ $order->customer_phone }}"
               class="w-full border p-2 mb-3 rounded" required>

        <input type="text" name="size"
               value="{{ $order->size }}"
               class="w-full border p-2 mb-3 rounded" required>

        <input type="number" name="quantity"
               value="{{ $order->quantity }}"
               class="w-full border p-2 mb-3 rounded" required>

        <input type="number" name="total_price"
               value="{{ $order->total_price }}"
               class="w-full border p-2 mb-3 rounded" required>

        <select name="payment_method" class="w-full border p-2 mb-3 rounded">
            <option value="COD" {{ $order->payment_method=='COD'?'selected':'' }}>COD</option>
            <option value="Transfer" {{ $order->payment_method=='Transfer'?'selected':'' }}>Transfer</option>
        </select>

        <select name="status" class="w-full border p-2 mb-4 rounded">
            <option value="pending" {{ $order->status=='pending'?'selected':'' }}>Pending</option>
            <option value="paid" {{ $order->status=='paid'?'selected':'' }}>Paid</option>
            <option value="process" {{ $order->status=='process'?'selected':'' }}>Process</option>
            <option value="done" {{ $order->status=='done'?'selected':'' }}>Done</option>
        </select>

        <div class="flex gap-3">
            <button class="px-5 py-2 bg-yellow-500 text-white rounded font-bold">
                Update
            </button>

            <a href="{{ route('admin.orders.index') }}"
               class="px-5 py-2 bg-gray-200 rounded font-bold">
                Batal
            </a>
        </div>
    </form>

</div>
@endsection
