@extends('admin.layouts.app')

@section('content')
<div class="bg-white rounded-xl shadow p-6">

    <div class="flex justify-between mb-6">
        <h1 class="text-2xl font-black">Manajemen Order</h1>

        <a href="{{ route('admin.orders.create') }}"
           class="px-4 py-2 bg-green-600 text-white rounded font-bold">
            + Tambah Order
        </a>
    </div>

    <table class="w-full border text-sm">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-2">ID</th>
                <th>Customer</th>
                <th>Phone</th>
                <th>Size</th>
                <th>Qty</th>
                <th>Total</th>
                <th>Payment</th>
                <th>Status</th>
                <th>Tanggal</th>
                <th width="200">Aksi</th>
            </tr>
        </thead>

        <tbody>
            @foreach($orders as $o)
            <tr class="border-t">
                <td class="p-2">{{ $o->id }}</td>
                <td>{{ $o->customer_name }}</td>
                <td>{{ $o->customer_phone }}</td>
                <td>{{ $o->size }}</td>
                <td>{{ $o->quantity }}</td>
                <td>Rp {{ number_format($o->total_price,0,',','.') }}</td>
                <td>{{ $o->payment_method }}</td>
                <td>
                    <span class="px-2 py-1 rounded text-xs
                        {{ $o->status == 'pending' ? 'bg-yellow-200' : 'bg-green-200' }}">
                        {{ $o->status }}
                    </span>
                </td>
                <td>{{ $o->order_date }}</td>
                <td class="flex gap-2 p-2">

                    
                    <a href="{{ route('admin.orders.struk', $o->id) }}"
                       target="_blank"
                       class="px-3 py-1 bg-blue-600 text-white rounded font-bold">
                        Receipt
                    </a>

                    
                    <a href="{{ route('admin.orders.edit', $o->id) }}"
                       class="px-3 py-1 bg-yellow-500 text-white rounded font-bold">
                        Edit
                    </a>

                    
                    <form action="{{ route('admin.orders.destroy', $o->id) }}"
                          method="POST"
                          onsubmit="return confirm('Hapus order ini?')">
                        @csrf
                        @method('DELETE')

                        <button class="px-3 py-1 bg-red-600 text-white rounded font-bold">
                            Hapus
                        </button>
                    </form>

                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

</div>
@endsection
