<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Struk Order</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        .container {
            width: 100%;
            border: 1px dashed #333;
            padding: 15px;
        }
        h2 {
            text-align: center;
            margin-bottom: 10px;
        }
        .row {
            margin-bottom: 6px;
        }
        .label {
            font-weight: bold;
            width: 120px;
            display: inline-block;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        th, td {
            border: 1px solid #333;
            padding: 6px;
            text-align: left;
        }
        .total {
            font-weight: bold;
            font-size: 14px;
        }
        .footer {
            margin-top: 15px;
            text-align: center;
            font-size: 11px;
        }
    </style>
</head>
<body>

<div class="container">

    <h2>STRUK PEMBELIAN</h2>

    <div class="row">
        <span class="label">Order ID</span>: {{ $order->id }}
    </div>

    <div class="row">
        <span class="label">Tanggal</span>: {{ $order->order_date }}
    </div>

    <div class="row">
        <span class="label">Customer</span>: {{ $order->customer_name }}
    </div>

    <div class="row">
        <span class="label">Phone</span>: {{ $order->customer_phone }}
    </div>

    <div class="row">
        <span class="label">Alamat</span>: {{ $order->customer_address }}
    </div>

    <table>
        <thead>
            <tr>
                <th>Size</th>
                <th>Qty</th>
                <th>Payment</th>
                <th>Status</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>{{ $order->size }}</td>
                <td>{{ $order->quantity }}</td>
                <td>{{ $order->payment_method }}</td>
                <td>{{ $order->status }}</td>
                <td>Rp {{ number_format($order->total_price,0,',','.') }}</td>
            </tr>
        </tbody>
    </table>

    <div class="row total" style="margin-top:10px;">
        Total Bayar : Rp {{ number_format($order->total_price,0,',','.') }}
    </div>

    <div class="footer">
        Terima kasih telah berbelanja 🙏 <br>
        Sistem Penjualan - Admin Panel
    </div>

</div>

</body>
</html>
