@extends('admin.layouts.app')

@section('content')

<h1 class="text-2xl font-black mb-6">Tambah Produk</h1>

<form method="POST"
      action="{{ route('admin.products.store') }}"
      class="bg-white p-6 rounded-xl shadow max-w-lg">
    @csrf

    <div class="mb-4">
        <label class="text-sm font-bold">Nama Produk</label>
        <input type="text" name="name"
               class="w-full border rounded px-3 py-2">
    </div>

    <div class="mb-4">
        <label class="text-sm font-bold">Deskripsi</label>
        <textarea name="description"
                  class="w-full border rounded px-3 py-2"></textarea>
    </div>

    <div class="mb-4">
        <label class="text-sm font-bold">Nama File Gambar</label>
        <input type="text" name="image"
               placeholder="contoh: sepatu.jpg"
               class="w-full border rounded px-3 py-2">
        <p class="text-xs text-gray-500 mt-1">
            Simpan gambar di folder <b>public/images</b>
        </p>
    </div>

    <div class="mb-4">
        <label class="text-sm font-bold">Harga</label>
        <input type="number" name="price"
               class="w-full border rounded px-3 py-2">
    </div>

    <div class="mb-4">
        <label class="text-sm font-bold">Stok</label>
        <input type="number" name="stock"
               class="w-full border rounded px-3 py-2">
    </div>

    <button class="px-4 py-2 bg-blue-600 text-white rounded">
        Simpan
    </button>
</form>

@endsection
