@extends('admin.layouts.app')

@section('content')

<h1 class="text-2xl font-black mb-6">Edit Produk</h1>

<form method="POST"
      action="{{ route('admin.products.update', $product->id) }}"
      class="bg-white p-6 rounded-xl shadow max-w-lg">
    @csrf
    @method('PUT')

    
    <div class="mb-4">
        <img
            src="{{ asset('images/' . ($product->image ?? 'no-image.png')) }}"
            class="w-full h-48 object-cover rounded">
    </div>

    <div class="mb-4">
        <label class="text-sm font-bold">Nama Produk</label>
        <input type="text" name="name"
               value="{{ $product->name }}"
               class="w-full border rounded px-3 py-2">
    </div>

    <div class="mb-4">
        <label class="text-sm font-bold">Deskripsi</label>
        <textarea name="description"
                  class="w-full border rounded px-3 py-2">{{ $product->description }}</textarea>
    </div>

    <div class="mb-4">
        <label class="text-sm font-bold">Nama File Gambar</label>
        <input type="text" name="image"
               value="{{ $product->image }}"
               class="w-full border rounded px-3 py-2">
    </div>

    <div class="mb-4">
        <label class="text-sm font-bold">Harga</label>
        <input type="number" name="price"
               value="{{ $product->price }}"
               class="w-full border rounded px-3 py-2">
    </div>

    <div class="mb-4">
        <label class="text-sm font-bold">Stok</label>
        <input type="number" name="stock"
               value="{{ $product->stock }}"
               class="w-full border rounded px-3 py-2">
    </div>

    <button class="px-4 py-2 bg-yellow-500 text-white rounded">
        Update
    </button>
</form>

@endsection
