@extends('admin.layouts.app')

@section('content')

<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-black">Manajemen Produk</h1>

    <a href="{{ route('admin.products.create') }}"
       class="px-4 py-2 bg-blue-600 text-white rounded-lg text-sm font-bold">
        + Tambah Produk
    </a>
</div>

@if (session('success'))
    <div class="mb-4 p-3 bg-green-100 text-green-700 rounded">
        {{ session('success') }}
    </div>
@endif

<div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-6">

@foreach ($products as $product)
    <div class="bg-white rounded-xl shadow overflow-hidden">

        
        <img
            src="{{ asset('images/' . ($product->image ?? 'no-image.png')) }}"
            class="w-full h-40 object-cover"
            alt="{{ $product->name }}">

        <div class="p-5">
            <h2 class="font-bold text-lg">{{ $product->name }}</h2>

            <p class="text-sm text-gray-500 my-2">
                {{ $product->description }}
            </p>

            <div class="text-sm mb-4">
                <div>Harga: <b>Rp {{ number_format($product->price,0,',','.') }}</b></div>
                <div>Stok: <b>{{ $product->stock }}</b></div>
            </div>

            <div class="flex gap-2">
                <a href="{{ route('admin.products.edit', $product->id) }}"
                   class="px-3 py-1 bg-yellow-400 text-sm rounded">
                    Edit
                </a>

                <form action="{{ route('admin.products.destroy', $product->id) }}"
                      method="POST"
                      onsubmit="return confirm('Yakin hapus produk?')">
                    @csrf
                    @method('DELETE')
                    <button class="px-3 py-1 bg-red-600 text-white text-sm rounded">
                        Hapus
                    </button>
                </form>
            </div>
        </div>

    </div>
@endforeach

</div>

@endsection
