<!DOCTYPE html>
<html>
<head>
    <title>Dashboard</title>
    <style>
        body { font-family: 'Segoe UI', sans-serif; background-color: #f9f9f9; margin: 0; }
        .navbar { background-color: #800000; color: white; padding: 15px 50px; display: flex; justify-content: space-between; align-items: center; }
        .navbar h2 { margin: 0; font-size: 20px; }
        .main-content { padding: 50px; text-align: center; }
        .card { background: white; padding: 40px; border-radius: 10px; display: inline-block; box-shadow: 0 2px 10px rgba(0,0,0,0.05); min-width: 400px; }
        h3 { color: #800000; margin-bottom: 5px; }
        p { color: #666; margin-bottom: 30px; }
        .logout-btn { background-color: transparent; color: #800000; border: 2px solid #800000; padding: 8px 20px; border-radius: 5px; cursor: pointer; font-weight: bold; transition: 0.3s; }
        .logout-btn:hover { background-color: #800000; color: white; }
    </style>
</head>
<body>
    <div class="navbar">
        <h2>My Dashboard</h2>
        <form method="POST" action="/logout">
            @csrf
            <button type="submit" class="logout-btn" style="color: white; border-color: white;">Logout</button>
        </form>
    </div>

    <div class="main-content">
        <div class="card">
            <h3>Halo, {{ auth()->user()->name }}!</h3>
            <p>Anda berhasil masuk ke dalam sistem.</p>
            <hr style="border: 0; border-top: 1px solid #eee; margin-bottom: 20px;">
            <p>Ini adalah halaman utama dashboard Anda.</p>
        </div>
    </div>
</body>
</html>