<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checkout - Wayah Pesa Collection</title>

    <script src="https://cdn.tailwindcss.com"></script>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        maroon: {
                            50: '#fff1f2',
                            100: '#ffe4e6',
                            800: '#800000',
                            900: '#660000',
                            950: '#450a0a'
                        }
                    },
                    fontFamily: {
                        sans: ['Plus Jakarta Sans', 'sans-serif']
                    }
                }
            }
        }
    </script>
    <style>
        body { background-color: #fcfcfc; }
        .form-input-focus:focus {
            border-color: #800000 !important;
            background-color: white !important;
            box-shadow: 0 0 0 4px rgba(128, 0, 0, 0.05);
        }
    </style>
</head>
<body class="min-h-screen font-sans antialiased text-gray-900">


@if (session('success'))
<script>
    document.addEventListener('DOMContentLoaded', function () {
        Swal.fire({
            icon: 'success',
            title: 'Pesanan Berhasil!',
            text: "{{ session('success') }}",
            confirmButtonColor: '#800000',
            timer: 3000
        });
    });
</script>
@endif

@if ($errors->any())
<script>
    document.addEventListener('DOMContentLoaded', function () {
        Swal.fire({
            icon: 'error',
            title: 'Gagal!',
            html: `{!! implode('<br>', $errors->all()) !!}`,
            confirmButtonColor: '#800000'
        });
    });
</script>
@endif

<nav class="bg-maroon-800 text-white px-8 py-5 shadow-2xl sticky top-0 z-50">
    <div class="max-w-7xl mx-auto flex justify-between items-center">
        <div class="flex items-center gap-2">
            <div class="w-8 h-8 bg-white/20 rounded-lg backdrop-blur-sm flex items-center justify-center font-black italic">M</div>
            <h1 class="font-extrabold text-2xl tracking-tighter italic uppercase">MAROON<span class="text-red-400">COLLECTION</span></h1>
        </div>
        <a href="{{ url('/products') }}" class="flex items-center gap-2 text-sm font-bold bg-white/10 hover:bg-white/20 px-4 py-2 rounded-xl transition-all">
            ← Kembali
        </a>
    </div>
</nav>

<div class="max-w-7xl mx-auto px-6 lg:px-8 py-12">
    <div class="grid grid-cols-1 lg:grid-cols-12 gap-10 items-start">
        
        <div class="lg:col-span-7">
            <div class="bg-white rounded-[2rem] shadow-xl border border-gray-100 overflow-hidden">
                <div class="p-8 lg:p-12">
                    <div class="flex items-center gap-4 mb-10">
                        <div class="h-12 w-1.5 bg-maroon-800 rounded-full"></div>
                        <div>
                            <h2 class="text-3xl font-black text-gray-900 tracking-tight">Formulir Pesanan</h2>
                            <p class="text-gray-500 font-medium">Isi detail lengkap untuk pengiriman barang.</p>
                        </div>
                    </div>

                    <form action="{{ route('orders.store') }}" method="POST" class="space-y-7">
                        @csrf
                        
                        <input type="hidden" name="product_id" value="{{ $product->id }}">
                        <input type="hidden" name="payment_method" value="COD">

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            <div class="space-y-2">
                                <label class="block font-bold text-[13px] text-maroon-800 uppercase tracking-[0.15em] ml-1">Nama Pemesan</label>
                                <input type="text" name="customer_name" placeholder="Nama Lengkap" required
                                    class="w-full p-4 bg-gray-50 border-2 border-gray-50 rounded-2xl outline-none font-semibold form-input-focus transition-all">
                            </div>

                            <div class="space-y-2">
                                <label class="block font-bold text-[13px] text-maroon-800 uppercase tracking-[0.15em] ml-1">No WhatsApp</label>
                                <input type="text" name="customer_phone" placeholder="Contoh: 0812..." required
                                    class="w-full p-4 bg-gray-50 border-2 border-gray-50 rounded-2xl outline-none font-semibold form-input-focus transition-all">
                            </div>
                        </div>

                        <div class="space-y-2">
                            <label class="block font-bold text-[13px] text-maroon-800 uppercase tracking-[0.15em] ml-1">Alamat Lengkap</label>
                            <textarea name="customer_address" rows="3" placeholder="Jl. Nama Jalan No. 00, RT/RW, Kec, Kota/Kab" required
                                class="w-full p-4 bg-gray-50 border-2 border-gray-50 rounded-2xl outline-none font-semibold form-input-focus transition-all resize-none"></textarea>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 pt-2">
                            <div class="space-y-2">
                                <label class="block font-bold text-[13px] text-maroon-800 uppercase tracking-[0.15em] ml-1">Pilih Ukuran</label>
                                <div class="relative">
                                    <select name="size" required
                                        class="w-full p-4 bg-gray-50 border-2 border-gray-50 rounded-2xl outline-none font-bold appearance-none cursor-pointer form-input-focus transition-all">
                                        <option value="">-- Pilih Ukuran --</option>
                                        <option value="S">S - Small</option>
                                        <option value="M">M - Medium</option>
                                        <option value="L">L - Large</option>
                                        <option value="XL">XL - Extra Large</option>
                                    </select>
                                    <div class="absolute right-4 top-1/2 -translate-y-1/2 pointer-events-none text-maroon-800">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" /></svg>
                                    </div>
                                </div>
                            </div>

                            <div class="space-y-2">
                                <label class="block font-bold text-[13px] text-maroon-800 uppercase tracking-[0.15em] ml-1">Jumlah</label>
                                <input type="number" name="quantity" min="1" value="1" required
                                    class="w-full p-4 bg-gray-50 border-2 border-gray-50 rounded-2xl outline-none font-bold form-input-focus transition-all">
                            </div>
                        </div>

                        <div class="pt-10">
                            <button type="submit"
                                class="group w-full bg-maroon-800 hover:bg-maroon-950 text-white py-6 rounded-2xl font-black uppercase tracking-[0.25em] transition-all shadow-xl shadow-maroon-100 flex items-center justify-center gap-4 active:scale-[0.98]">
                                BUAT PESANAN SEKARANG
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 transition-transform group-hover:translate-x-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="3" d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                </svg>
                            </button>
                            <div class="mt-6 flex items-center justify-center gap-6 text-gray-400 font-bold text-[10px] tracking-widest uppercase">
                                <span class="flex items-center gap-1"><svg class="w-4 h-4 text-green-500" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg> Aman</span>
                                <span class="flex items-center gap-1"><svg class="w-4 h-4 text-green-500" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg> Cepat</span>
                                <span class="flex items-center gap-1"><svg class="w-4 h-4 text-green-500" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path></svg> Terpercaya</span>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="lg:col-span-5 lg:sticky lg:top-32">
            <div class="bg-maroon-800 rounded-[2rem] shadow-2xl overflow-hidden relative border border-maroon-900">
                <div class="absolute top-0 right-0 -mr-16 -mt-16 w-64 h-64 bg-maroon-900 rounded-full opacity-50 blur-3xl"></div>
                <div class="absolute bottom-0 left-0 -ml-16 -mb-16 w-64 h-64 bg-maroon-900 rounded-full opacity-50 blur-3xl"></div>

                <div class="p-8 lg:p-10 relative z-10 text-white">
                    <div class="inline-block px-4 py-1.5 bg-white/10 rounded-full text-[10px] font-black tracking-widest uppercase mb-6 border border-white/10 backdrop-blur-md">
                        Detail Pesanan Anda
                    </div>

                    <div class="bg-white/5 rounded-3xl p-6 border border-white/10 backdrop-blur-sm mb-8">
                        <div class="flex items-start gap-5">
                            <div class="w-20 h-20 bg-white/10 rounded-2xl flex-shrink-0 flex items-center justify-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-10 w-10 text-maroon-100" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-black leading-tight">{{ $product->name }}</h3>
                                <p class="text-maroon-200 text-xs mt-1 font-medium tracking-wide uppercase italic">Edisi Koleksi Maroon</p>
                                <div class="mt-3 inline-flex items-center px-3 py-1 bg-maroon-900/50 rounded-lg text-[11px] font-bold text-red-300 gap-1.5">
                                    <span class="w-2 h-2 bg-red-400 rounded-full animate-pulse"></span> Stok Tersedia
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-4 pt-4 border-t border-white/10">
                        <div class="flex justify-between items-center">
                            <span class="text-maroon-200 font-semibold text-sm">Metode Bayar:</span>
                            <span class="font-black text-sm tracking-widest bg-white/10 px-3 py-1 rounded-lg border border-white/10">COD (Bayar di Tempat)</span>
                        </div>
                        <div class="flex justify-between items-end pt-2">
                            <div>
                                <p class="text-maroon-200 text-xs font-bold uppercase tracking-widest">Harga Satuan</p>
                                <p class="text-3xl font-black tracking-tighter mt-1 italic">Rp {{ number_format($product->price, 0, ',', '.') }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="mt-8 p-6 bg-maroon-950/40 rounded-[1.5rem] border border-white/5 space-y-3">
                        <div class="flex items-center gap-3 text-sm">
                            <div class="w-5 h-5 bg-green-500/20 text-green-400 rounded-full flex items-center justify-center">✓</div>
                            <span class="font-medium text-maroon-50 text-xs italic">Garansi bahan premium original</span>
                        </div>
                        <div class="flex items-center gap-3 text-sm">
                            <div class="w-5 h-5 bg-green-500/20 text-green-400 rounded-full flex items-center justify-center">✓</div>
                            <span class="font-medium text-maroon-50 text-xs italic">Pengemasan eksklusif maroonbox</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

</body>
</html>
