<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Pesanan - Wayah Pesa Collection</title>

    <script src="https://cdn.tailwindcss.com"></script>

    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        maroon: {
                            700: '#991b1b',
                            800: '#800000',
                            900: '#660000',
                        }
                    },
                    fontFamily: { sans: ['Plus Jakarta Sans', 'sans-serif'] }
                }
            }
        }
    </script>
</head>

<body class="bg-gray-50 min-h-screen font-sans antialiased text-gray-900">


<nav class="glass-nav sticky top-0 z-50 shadow-xl border-b border-maroon-700 bg-maroon-800">
    <div class="max-w-7xl mx-auto px-4 py-4 flex justify-between items-center">

        <div class="flex items-center gap-2">
            <div class="w-10 h-10 bg-white rounded-xl flex items-center justify-center shadow-lg">
                <span class="text-maroon-800 font-black text-xl italic">WP</span>
            </div>
            <h1 class="text-xl md:text-2xl font-black text-white italic uppercase">
                WAYAH PESA <span class="text-red-400">COLLECTION</span>
            </h1>
        </div>

        
        <div class="text-white font-bold">
            Hi, {{ Auth::user()->name }}
        </div>

    </div>
</nav>

<main class="max-w-7xl mx-auto px-4 py-16">

    <h2 class="text-3xl font-black mb-10">🧾 Riwayat Pesanan Saya</h2>

    @if($orders->isEmpty())
        <div class="bg-white p-16 rounded-3xl shadow text-center">
            <p class="text-gray-400 font-bold uppercase">
                Belum ada pesanan 😢
            </p>
        </div>
    @else

    <div class="bg-white rounded-3xl shadow-xl overflow-hidden">

        <table class="w-full text-sm">

            <thead class="bg-maroon-800 text-white">
                <tr>
                    <th class="px-6 py-4 text-left">No</th>
                    <th class="px-6 py-4 text-left">Produk</th>
                    <th class="px-6 py-4 text-left">Ukuran</th>
                    <th class="px-6 py-4 text-left">Jumlah</th>
                    <th class="px-6 py-4 text-left">Total</th>
                    <th class="px-6 py-4 text-left">Status</th>
                    <th class="px-6 py-4 text-left">Tanggal</th>
                    <th class="px-6 py-4 text-left">Aksi</th> 
                </tr>
            </thead>

            <tbody class="divide-y">

                @foreach ($orders as $index => $order)
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 font-bold">
                            {{ $index + 1 }}
                        </td>

                        <td class="px-6 py-4">
                            {{ $order->product_id }}
                        </td>

                        <td class="px-6 py-4">
                            {{ $order->size }}
                        </td>

                        <td class="px-6 py-4">
                            {{ $order->quantity }}
                        </td>

                        <td class="px-6 py-4 font-bold text-maroon-800">
                            Rp {{ number_format($order->total_price, 0, ',', '.') }}
                        </td>

                        <td class="px-6 py-4">
                            @if($order->status == 'pending')
                                <span class="px-3 py-1 rounded-full bg-yellow-100 text-yellow-700 font-bold">
                                    Pending
                                </span>
                            @elseif($order->status == 'proses')
                                <span class="px-3 py-1 rounded-full bg-blue-100 text-blue-700 font-bold">
                                    Proses
                                </span>
                            @elseif($order->status == 'selesai')
                                <span class="px-3 py-1 rounded-full bg-green-100 text-green-700 font-bold">
                                    Selesai
                                </span>
                            @else
                                <span class="px-3 py-1 rounded-full bg-gray-100 text-gray-700 font-bold">
                                    {{ ucfirst($order->status) }}
                                </span>
                            @endif
                        </td>

                        <td class="px-6 py-4 text-gray-500">
                            {{ \Carbon\Carbon::parse($order->order_date)->format('d M Y') }}
                        </td>

                        <td class="px-6 py-4">
                            <a href="{{ route('admin.orders.struk', $order->id) }}"
                            target="_blank"
                            class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-lg font-bold text-xs shadow">
                                🧾 Receipt
                            </a>
                        </td>

                    </tr>
                @endforeach

            </tbody>

        </table>

    </div>

    @endif

</main>

<footer class="bg-maroon-900 text-white py-10 text-center">
    <p class="text-sm opacity-70">© 2024 Wayah Pesa Collection</p>
</footer>

</body>
</html>
