<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Premium Maroon Store - Koleksi Eksklusif</title>

    <script src="https://cdn.tailwindcss.com"></script>

    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        maroon: {
                            50: '#fff1f2',
                            100: '#ffe4e6',
                            200: '#fecdd3',
                            700: '#991b1b',
                            800: '#800000',
                            900: '#660000',
                            950: '#450a0a',
                        }
                    },
                    fontFamily: { sans: ['Plus Jakarta Sans', 'sans-serif'] }
                }
            }
        }
    </script>

    <style>
        .glass-nav {
            background: rgba(128, 0, 0, 0.95);
            backdrop-filter: blur(10px);
        }
        .hero-pattern {
            background-color: #800000;
            background-image: url("https://www.transparenttextures.com/patterns/cubes.png");
        }
    </style>
</head>

<body class="bg-gray-50 min-h-screen font-sans antialiased text-gray-900">

<nav class="glass-nav sticky top-0 z-50 shadow-xl border-b border-maroon-700">
    <div class="max-w-7xl mx-auto px-4 py-4 flex justify-between items-center">

        
        <div class="flex items-center gap-2">
            <div class="w-10 h-10 bg-white rounded-xl flex items-center justify-center shadow-lg">
                <span class="text-maroon-800 font-black text-xl italic">WP</span>
            </div>
            <h1 class="text-xl md:text-2xl font-black text-white italic uppercase">
                WAYAH PESA <span class="text-red-400">COLLECTION</span>
            </h1>
        </div>

        
        <div class="flex items-center gap-6 relative">

            @auth
                
                <div class="relative group">

                    <button class="flex items-center gap-3 bg-white/10 px-4 py-2 rounded-xl text-white font-bold hover:bg-white/20 transition">
                        <span>Hi, {{ Auth::user()->name }}</span>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                        </svg>
                    </button>

                    
                    <div class="absolute right-0 mt-2 w-48 bg-white rounded-xl shadow-xl overflow-hidden opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all">

                        <a href="/orders/history"
                           class="block px-4 py-3 hover:bg-gray-100 font-semibold text-gray-700">
                            🧾 Pesanan Saya
                        </a>

                        <form method="POST" action="/logout">
                            @csrf
                            <button type="submit"
                                class="w-full text-left px-4 py-3 hover:bg-red-50 font-semibold text-red-600">
                                🚪 Logout
                            </button>
                        </form>
                    </div>
                </div>

            @else
                
                <a href="/login"
                   class="px-4 py-2 border-2 border-white text-white rounded-xl font-bold hover:bg-white hover:text-maroon-800 transition">
                    Login
                </a>

                <a href="/register"
                   class="px-4 py-2 bg-white text-maroon-800 rounded-xl font-bold hover:bg-gray-100 transition">
                    Register
                </a>
            @endauth

        </div>

    </div>
</nav>


<section class="hero-pattern text-white py-20 px-4 text-center">
    <h2 class="text-4xl md:text-6xl font-black mb-6">
        Tampil Elegan dengan <br>
        <span class="text-red-300">Nuansa Maroon</span>
    </h2>
    <p class="max-w-2xl mx-auto text-maroon-100">
        Temukan koleksi pakaian premium dengan kualitas terbaik.
    </p>
</section>

<main id="koleksi" class="max-w-7xl mx-auto px-4 py-20">

    <div class="mb-12">
        <h3 class="text-3xl font-black">Koleksi Terbaru Kami</h3>
    </div>

    @if($products->isEmpty())
        <div class="text-center py-32 bg-white rounded-3xl border-2 border-dashed">
            <p class="text-gray-400 font-bold uppercase">Koleksi Belum Tersedia</p>
        </div>
    @else
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-10">
            @foreach ($products as $product)
                <div class="group bg-white rounded-3xl overflow-hidden shadow-xl border flex flex-col">

                    
                    <div class="relative h-80 overflow-hidden bg-gray-100">
                        @if($product->image)
                            <img
                                src="{{ asset('images/' . $product->image) }}"
                                alt="{{ $product->name }}"
                                class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700"
                            >
                        @else
                            <div class="flex items-center justify-center h-full">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-16 w-16 text-gray-300" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16" />
                                </svg>
                            </div>
                        @endif
                    </div>

                    
                    <div class="p-6 flex flex-col flex-grow">
                        <h2 class="font-black text-lg">{{ $product->name }}</h2>

                        <p class="text-sm text-gray-400 mt-2 line-clamp-2">
                            {{ $product->description }}
                        </p>

                        <div class="mt-4 flex justify-between text-sm">
                            <span class="font-bold text-maroon-800">
                                Rp {{ number_format($product->price, 0, ',', '.') }}
                            </span>
                            <span class="text-gray-500">
                                Stok: {{ $product->stock }}
                            </span>
                        </div>

                        <div class="mt-6 flex gap-2">
                            <button class="flex-1 bg-maroon-800 text-white py-3 rounded-xl font-bold">
                                Beli Sekarang
                            </button>
                            <a href="{{ route('produk.show', $product->id) }}"
                               class="px-4 py-3 border-2 border-maroon-800 text-maroon-800 rounded-xl font-bold">
                                Detail
                            </a>
                        </div>
                    </div>

                </div>
            @endforeach
        </div>
    @endif

</main>

<footer class="bg-maroon-950 text-white py-10 text-center">
    <p class="text-sm opacity-70">© 2024 Wayah Pesa Collection</p>
</footer>

</body>
</html>
