<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail {{ $product->name }} - Maroon Collection</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;600;700&display=swap" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        maroon: {
                            50: '#fff1f2',
                            600: '#b91c1c',
                            700: '#991b1b',
                            800: '#800000',
                            950: '#450a0a',
                        }
                    },
                    fontFamily: { sans: ['Plus Jakarta Sans', 'sans-serif'] }
                }
            }
        }
    </script>
</head>
<body class="bg-gray-50 min-h-screen font-sans">

    <nav class="bg-maroon-800 shadow-xl">
        <div class="max-w-7xl mx-auto px-6 py-5 flex justify-between items-center">
            <h1 class="text-xl font-bold text-white tracking-tighter italic">
                MAROON<span class="text-red-400">COLLECTION</span>
            </h1>
            <a href="/products" class="flex items-center gap-2 text-white/90 hover:text-white text-sm font-bold transition-all group">
                <span class="transform group-hover:-translate-x-1 transition-transform">←</span> Kembali ke Katalog
            </a>
        </div>
    </nav>

    <div class="max-w-6xl mx-auto px-4 py-12 md:py-20">
        <div class="bg-white rounded-[2.5rem] shadow-2xl overflow-hidden border border-gray-100">
            <div class="grid grid-cols-1 lg:grid-cols-2">
                
                <div class="relative bg-gray-100 flex items-center justify-center min-h-[400px] lg:h-full">
                    <div class="absolute inset-0 bg-gradient-to-br from-maroon-950/5 to-transparent"></div>
                    <div class="flex flex-col items-center">
                        <img
                                src="{{ asset('images/' . $product->image) }}"
                                alt="{{ $product->name }}"
                                class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700"
                            >   
                        <span class="text-gray-400 mt-4 font-medium tracking-widest uppercase text-xs">Premium Product Image</span>
                    </div>
                    <div class="absolute top-6 left-6">
                        <span class="bg-white/90 backdrop-blur-sm text-maroon-800 px-4 py-1.5 rounded-full text-xs font-black shadow-sm border border-maroon-100">STOK TERBATAS</span>
                    </div>
                </div>

                <div class="p-8 md:p-14 lg:p-16 flex flex-col justify-center">
                    <nav class="flex mb-6 text-[10px] font-bold uppercase tracking-[0.2em] text-gray-400">
                        <span>Shop</span> <span class="mx-2">/</span> <span>Apparel</span> <span class="mx-2">/</span> <span class="text-maroon-600">Premium</span>
                    </nav>

                    <h2 class="text-4xl md:text-5xl font-black text-gray-900 leading-tight mb-4">
                        {{ $product->name }}
                    </h2>

                    <div class="flex flex-wrap gap-3 mb-8">
                        <div class="flex items-center gap-2 bg-maroon-50 text-maroon-700 px-4 py-2 rounded-xl border border-maroon-100">
                            <span class="text-[10px] font-black uppercase opacity-60">Ukuran</span>
                            <span class="font-bold text-sm">{{ $product->size ?? 'Universal' }}</span>
                        </div>
                        <div class="flex items-center gap-2 bg-green-50 text-green-700 px-4 py-2 rounded-xl border border-green-100">
                            <span class="text-[10px] font-black uppercase opacity-60">Status</span>
                            <span class="font-bold text-sm">Ready {{ $product->stock }} Unit</span>
                        </div>
                    </div>

                    <div class="mb-8">
                        <h3 class="text-xs font-black uppercase text-gray-400 tracking-widest mb-3">Deskripsi Produk</h3>
                        <p class="text-gray-600 leading-relaxed text-lg italic">
                            "{{ $product->description }}"
                        </p>
                    </div>

                    <div class="bg-gray-50 p-6 rounded-3xl border border-gray-100 mb-10">
                        <p class="text-xs font-black text-gray-400 uppercase tracking-widest mb-1">Harga Penawaran</p>
                        <div class="flex items-baseline gap-2">
                            <span class="text-2xl font-bold text-maroon-800">Rp</span>
                            <span class="text-5xl font-black text-maroon-800 tracking-tighter">
                                {{ number_format($product->price, 0, ',', '.') }}
                            </span>
                        </div>
                    </div>

                    <div class="flex flex-col sm:flex-row gap-4">
                        <a href="{{ route('orders.create', $product->id) }}"
   class="flex-[2] bg-maroon-800 hover:bg-maroon-950 text-white py-5 rounded-2xl
          font-black text-sm uppercase tracking-widest transition-all
          shadow-xl shadow-maroon-200 active:scale-[0.98]
          flex items-center justify-center gap-3">
    Checkout Sekarang
</a>

                        <button class="flex-1 bg-white border-2 border-gray-200 hover:border-maroon-800 text-gray-600 hover:text-maroon-800 py-5 rounded-2xl font-bold text-sm transition-all flex items-center justify-center gap-2">
                            Simpan Wishlist
                        </button>
                    </div>

                    <p class="text-center text-[10px] text-gray-400 mt-8 font-medium uppercase tracking-widest">
                        Gratis Pengembalian dalam 7 Hari • Jaminan Kualitas 100%
                    </p>
                </div>

            </div>
        </div>
    </div>

</body>
</html>