<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\PendapatanController;
use App\Http\Controllers\OrderCustomerController;

use App\Http\Controllers\Admin\DashboardAdminController;





Route::get('products', [ProductController::class, 'index']);
Route::get('/products/{id}', [ProductController::class, 'show'])->name('produk.show');

Route::get('/orders/create/{product_id}', [OrderCustomerController::class, 'create'])
    ->name('orders.create');
 Route::get('/orders/history', [OrderCustomerController::class, 'history'])
        ->name('orders.history');


Route::post('/orders/store', [OrderCustomerController::class, 'store'])
    ->name('orders.store');




Route::get('/login', [AuthController::class, 'loginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);

Route::get('/register', [AuthController::class, 'registerForm']);
Route::post('/register', [AuthController::class, 'register']);

Route::post('/logout', [AuthController::class, 'logout'])->name('logout');




Route::get('/admin/login', [AdminAuthController::class, 'loginForm'])->name('admin.login');
Route::post('/admin/login', [AdminAuthController::class, 'login']);
Route::post('/admin/logout', [AdminAuthController::class, 'logout'])->name('admin.logout');
 
Route::prefix('admin')->name('admin.')->group(function () {

    Route::get('/products', [DashboardController::class, 'products'])->name('products');

    Route::get('/products/create', [DashboardController::class, 'create'])->name('products.create');

    Route::post('/products', [DashboardController::class, 'store'])->name('products.store');

    Route::get('/products/{id}/edit', [DashboardController::class, 'edit'])->name('products.edit');

    Route::put('/products/{id}', [DashboardController::class, 'update'])
        ->name('products.update');

    Route::delete('/products/{id}', [DashboardController::class, 'destroy'])
        ->name('products.destroy');
});


Route::get('/admin/dashboard', function () {
    return view('admin.dashboard.index');
})->name('admin.dashboard');

Route::prefix('admin')
    ->middleware('auth:admin')
    ->name('admin.')
    ->group(function () {

        Route::get('/customers', [CustomerController::class, 'index'])
            ->name('customers.index');

        Route::get('/customers/create', [CustomerController::class, 'create'])
            ->name('customers.create');

        Route::post('/customers', [CustomerController::class, 'store'])
            ->name('customers.store');

        Route::get('/customers/{customer}/edit', [CustomerController::class, 'edit'])
            ->name('customers.edit');

        Route::put('/customers/{customer}', [CustomerController::class, 'update'])
            ->name('customers.update');

        Route::delete('/customers/{customer}', [CustomerController::class, 'destroy'])
            ->name('customers.destroy');


        
        Route::get('/admins', [DashboardController::class, 'adminsIndex'])
            ->name('admins.index');

        Route::get('/admins/create', [DashboardController::class, 'adminsCreate'])
            ->name('admins.create');

        Route::post('/admins', [DashboardController::class, 'adminsStore'])
            ->name('admins.store');

        Route::get('/admins/{id}/edit', [DashboardController::class, 'adminsEdit'])
            ->name('admins.edit');

        Route::put('/admins/{id}', [DashboardController::class, 'adminsUpdate'])
            ->name('admins.update');

        Route::delete('/admins/{id}', [DashboardController::class, 'adminsDestroy'])
            ->name('admins.destroy');


        
        Route::get('/orders', [OrderController::class, 'index'])
            ->name('orders.index');

        Route::get('/orders/create', [OrderController::class, 'create'])
            ->name('orders.create');

        Route::post('/orders', [OrderController::class, 'store'])
            ->name('orders.store');

        Route::get('/orders/{id}/edit', [OrderController::class, 'edit'])
            ->name('orders.edit');

        Route::put('/orders/{id}', [OrderController::class, 'update'])
            ->name('orders.update');

        Route::delete('/orders/{id}', [OrderController::class, 'destroy'])
            ->name('orders.destroy');

        Route::get('/orders/{id}/struk', [OrderController::class, 'struk'])
            ->name('orders.struk');


        
        Route::get('/pendapatan', [PendapatanController::class, 'index'])
            ->name('pendapatan.index');

        
        Route::get('/pendapatan/export', [PendapatanController::class, 'exportPendapatanExcel'])
            ->name('pendapatan.export');

    });
