

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-xl shadow p-6 max-w-xl">

    <h1 class="text-2xl font-black mb-6">Edit Order</h1>

    <form action="<?php echo e(route('admin.orders.update', $order->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        
        <input type="hidden" name="product_id" value="<?php echo e($order->product_id); ?>">

        
        <input type="hidden" name="order_date" value="<?php echo e($order->order_date); ?>">

        <input type="text" name="customer_name"
               value="<?php echo e($order->customer_name); ?>"
               class="w-full border p-2 mb-3 rounded" required>

        <textarea name="customer_address"
                  class="w-full border p-2 mb-3 rounded" required><?php echo e($order->customer_address); ?></textarea>

        <input type="text" name="customer_phone"
               value="<?php echo e($order->customer_phone); ?>"
               class="w-full border p-2 mb-3 rounded" required>

        <input type="text" name="size"
               value="<?php echo e($order->size); ?>"
               class="w-full border p-2 mb-3 rounded" required>

        <input type="number" name="quantity"
               value="<?php echo e($order->quantity); ?>"
               class="w-full border p-2 mb-3 rounded" required>

        <input type="number" name="total_price"
               value="<?php echo e($order->total_price); ?>"
               class="w-full border p-2 mb-3 rounded" required>

        <select name="payment_method" class="w-full border p-2 mb-3 rounded">
            <option value="COD" <?php echo e($order->payment_method=='COD'?'selected':''); ?>>COD</option>
            <option value="Transfer" <?php echo e($order->payment_method=='Transfer'?'selected':''); ?>>Transfer</option>
        </select>

        <select name="status" class="w-full border p-2 mb-4 rounded">
            <option value="pending" <?php echo e($order->status=='pending'?'selected':''); ?>>Pending</option>
            <option value="paid" <?php echo e($order->status=='paid'?'selected':''); ?>>Paid</option>
            <option value="process" <?php echo e($order->status=='process'?'selected':''); ?>>Process</option>
            <option value="done" <?php echo e($order->status=='done'?'selected':''); ?>>Done</option>
        </select>

        <div class="flex gap-3">
            <button class="px-5 py-2 bg-yellow-500 text-white rounded font-bold">
                Update
            </button>

            <a href="<?php echo e(route('admin.orders.index')); ?>"
               class="px-5 py-2 bg-gray-200 rounded font-bold">
                Batal
            </a>
        </div>
    </form>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\uas-terbaru\resources\views/admin/orders/edit.blade.php ENDPATH**/ ?>