

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-xl shadow p-6">

    <div class="flex justify-between mb-6">
        <h1 class="text-2xl font-black">Manajemen Order</h1>

        <a href="<?php echo e(route('admin.orders.create')); ?>"
           class="px-4 py-2 bg-green-600 text-white rounded font-bold">
            + Tambah Order
        </a>
    </div>

    <table class="w-full border text-sm">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-2">ID</th>
                <th>Customer</th>
                <th>Phone</th>
                <th>Size</th>
                <th>Qty</th>
                <th>Total</th>
                <th>Payment</th>
                <th>Status</th>
                <th>Tanggal</th>
                <th width="200">Aksi</th>
            </tr>
        </thead>

        <tbody>
            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="border-t">
                <td class="p-2"><?php echo e($o->id); ?></td>
                <td><?php echo e($o->customer_name); ?></td>
                <td><?php echo e($o->customer_phone); ?></td>
                <td><?php echo e($o->size); ?></td>
                <td><?php echo e($o->quantity); ?></td>
                <td>Rp <?php echo e(number_format($o->total_price,0,',','.')); ?></td>
                <td><?php echo e($o->payment_method); ?></td>
                <td>
                    <span class="px-2 py-1 rounded text-xs
                        <?php echo e($o->status == 'pending' ? 'bg-yellow-200' : 'bg-green-200'); ?>">
                        <?php echo e($o->status); ?>

                    </span>
                </td>
                <td><?php echo e($o->order_date); ?></td>
                <td class="flex gap-2 p-2">

                    
                    <a href="<?php echo e(route('admin.orders.struk', $o->id)); ?>"
                       target="_blank"
                       class="px-3 py-1 bg-blue-600 text-white rounded font-bold">
                        Receipt
                    </a>

                    
                    <a href="<?php echo e(route('admin.orders.edit', $o->id)); ?>"
                       class="px-3 py-1 bg-yellow-500 text-white rounded font-bold">
                        Edit
                    </a>

                    
                    <form action="<?php echo e(route('admin.orders.destroy', $o->id)); ?>"
                          method="POST"
                          onsubmit="return confirm('Hapus order ini?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>

                        <button class="px-3 py-1 bg-red-600 text-white rounded font-bold">
                            Hapus
                        </button>
                    </form>

                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\uas-terbaru\resources\views/admin/orders/index.blade.php ENDPATH**/ ?>