<aside class="w-72 bg-maroon-950 text-white flex flex-col shadow-2xl">

    
    <div class="px-6 py-7 border-b border-white/10">
        <h1 class="text-2xl font-extrabold uppercase tracking-widest italic">
            Admin <span class="text-red-400">Panel</span>
        </h1>
        <p class="text-xs text-white/60 mt-2">
            <?php if(auth()->guard('admin')->check()): ?>
                Hi, <?php echo e(auth()->guard('admin')->user()->name); ?>

            <?php endif; ?>
        </p>
    </div>

    
    <nav class="flex-1 px-4 py-6 space-y-1 text-sm font-semibold">

        <?php
            $menuClass = 'flex items-center gap-4 px-4 py-3 rounded-xl transition-all duration-200';
            $active = 'bg-white/20 shadow-inner';
            $hover = 'hover:bg-white/10';
        ?>

        <a href="/admin/dashboard"
           class="<?php echo e($menuClass); ?> <?php echo e(request()->is('admin/dashboard') ? $active : $hover); ?>">
            <span class="text-lg">📊</span>
            <span>Dashboard</span>
        </a>

        <a href="/admin/products"
           class="<?php echo e($menuClass); ?> <?php echo e(request()->is('admin/products*') ? $active : $hover); ?>">
            <span class="text-lg">📦</span>
            <span>Manajemen Produk</span>
        </a>

        <a href="/admin/customers"
           class="<?php echo e($menuClass); ?> <?php echo e(request()->is('admin/customers*') ? $active : $hover); ?>">
            <span class="text-lg">👥</span>
            <span>Manajemen Customer</span>
        </a>

        <a href="/admin/orders"
           class="<?php echo e($menuClass); ?> <?php echo e(request()->is('admin/orders*') ? $active : $hover); ?>">
            <span class="text-lg">🧾</span>
            <span>Manajemen Orders</span>
        </a>

        <a href="/admin/admins"
           class="<?php echo e($menuClass); ?> <?php echo e(request()->is('admin/admins*') ? $active : $hover); ?>">
            <span class="text-lg">🛡️</span>
            <span>Manajemen Admin</span>
        </a>

            <a href="<?php echo e(route('admin.pendapatan.index')); ?>"
                class="<?php echo e($menuClass); ?> <?php echo e(request()->is('admin/pendapatan*') ? $active : $hover); ?>">
                <span class="text-lg">💰</span>
                <span>Pendapatan</span>
            </a>

    </nav>

    
    <div class="px-6 py-6 border-t border-white/10">
        <form method="POST" action="<?php echo e(route('admin.logout')); ?>">
            <?php echo csrf_field(); ?>
            <button type="submit"
                class="w-full flex items-center justify-center gap-3 px-4 py-3 rounded-xl
                       bg-gradient-to-r from-red-600 to-red-700
                       hover:from-red-700 hover:to-red-800
                       transition font-black uppercase text-xs tracking-widest shadow-lg">
                🚪 Logout
            </button>
        </form>
    </div>

</aside>
<?php /**PATH C:\laragon\www\uas-terbaru\resources\views/admin/layouts/sidebar.blade.php ENDPATH**/ ?>