<!DOCTYPE html>
<html>
<head>
    <title>Register</title>
    <style>
        body { font-family: 'Arial', sans-serif; background-color: #800000; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .container { background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 4px 15px rgba(0,0,0,0.3); width: 320px; text-align: center; }
        h2 { color: #333; margin-bottom: 20px; }
        input, textarea { width: 100%; padding: 10px; margin: 8px 0; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        button { width: 100%; padding: 10px; background-color: #333; color: white; border: none; border-radius: 4px; cursor: pointer; font-weight: bold; margin-top: 10px; }
        button:hover { background-color: #800000; transition: 0.3s; }
        a { color: #666; text-decoration: none; font-size: 14px; display: block; margin-top: 15px; }
        .error { background: #f8d7da; color: #721c24; padding: 8px; border-radius: 4px; font-size: 13px; margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Register</h2>

        <?php if($errors->any()): ?>
            <div class="error">
                <?php echo e($errors->first()); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="/register">
            <?php echo csrf_field(); ?>

            <input type="text" name="name" placeholder="Nama Lengkap" value="<?php echo e(old('name')); ?>">
            <input type="email" name="email" placeholder="Email" value="<?php echo e(old('email')); ?>">
            <input type="password" name="password" placeholder="Password">

            <input type="text" name="phone" placeholder="No HP" value="<?php echo e(old('phone')); ?>">
            <textarea name="address" placeholder="Alamat Lengkap"><?php echo e(old('address')); ?></textarea>

            <button type="submit">Daftar Sekarang</button>
        </form>

        <a href="/login">Sudah punya akun? Login</a>
    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\uas-terbaru\resources\views/auth/register.blade.php ENDPATH**/ ?>