<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-xl shadow p-6">

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-black">Manajemen Customer</h1>

        <a href="<?php echo e(route('admin.customers.create')); ?>"
           class="px-4 py-2 bg-green-600 text-white rounded font-bold">
            + Tambah Customer
        </a>
    </div>

    <table class="w-full border">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-3">Nama</th>
                <th>Email</th>
                <th>Phone</th>
                <th width="160">Aksi</th>
            </tr>
        </thead>

        <tbody>
            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="border-t">
                <td class="p-3"><?php echo e($customer->name); ?></td>
                <td><?php echo e($customer->email); ?></td>
                <td><?php echo e($customer->phone); ?></td>
                <td class="flex gap-2 p-3">

                    <a href="<?php echo e(route('admin.customers.edit', $customer->id)); ?>"
                       class="px-3 py-1 bg-yellow-500 text-white rounded font-bold">
                        Edit
                    </a>

                    <form action="<?php echo e(route('admin.customers.destroy', $customer->id)); ?>"
                          method="POST"
                          onsubmit="return confirm('Hapus customer ini?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>

                        <button class="px-3 py-1 bg-red-600 text-white rounded font-bold">
                            Hapus
                        </button>
                    </form>

                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\uas-terbaru\resources\views/admin/customers/index.blade.php ENDPATH**/ ?>