

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-xl shadow p-6">

    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-black">Laporan Pendapatan</h1>

        <a href="<?php echo e(route('admin.pendapatan.export')); ?>"
           class="px-4 py-2 bg-green-600 text-white rounded font-bold">
            Export Excel
        </a>
    </div>

    
    <div class="mb-6 p-4 bg-green-100 rounded text-lg font-bold">
        Total Pendapatan : 
        <span class="text-green-700">
            Rp <?php echo e(number_format($totalPendapatan,0,',','.')); ?>

        </span>
    </div>

    
    <table class="w-full border text-sm">
        <thead class="bg-gray-100">
            <tr>
                <th class="p-2">No</th>
                <th>Produk</th>
                <th>Jumlah Terjual</th>
                <th>Harga Satuan</th>
                <th>Total Pendapatan</th>
            </tr>
        </thead>

        <tbody>
            <?php $no=1; ?>
            <?php $__currentLoopData = $pendapatan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr class="border-t">
                <td class="p-2"><?php echo e($no++); ?></td>
                <td><?php echo e($p->nama_produk); ?></td>
                <td><?php echo e($p->total_jumlah); ?></td>
                <td>Rp <?php echo e(number_format($p->harga_satuan,0,',','.')); ?></td>
                <td class="font-bold text-green-700">
                    Rp <?php echo e(number_format($p->total_pendapatan,0,',','.')); ?>

                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\uas-terbaru\resources\views/admin/pendapatan/index.blade.php ENDPATH**/ ?>