

<?php $__env->startSection('content'); ?>

<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-black">Manajemen Produk</h1>

    <a href="<?php echo e(route('admin.products.create')); ?>"
       class="px-4 py-2 bg-blue-600 text-white rounded-lg text-sm font-bold">
        + Tambah Produk
    </a>
</div>

<?php if(session('success')): ?>
    <div class="mb-4 p-3 bg-green-100 text-green-700 rounded">
        <?php echo e(session('success')); ?>

    </div>
<?php endif; ?>

<div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-6">

<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="bg-white rounded-xl shadow overflow-hidden">

        
        <img
            src="<?php echo e(asset('images/' . ($product->image ?? 'no-image.png'))); ?>"
            class="w-full h-40 object-cover"
            alt="<?php echo e($product->name); ?>">

        <div class="p-5">
            <h2 class="font-bold text-lg"><?php echo e($product->name); ?></h2>

            <p class="text-sm text-gray-500 my-2">
                <?php echo e($product->description); ?>

            </p>

            <div class="text-sm mb-4">
                <div>Harga: <b>Rp <?php echo e(number_format($product->price,0,',','.')); ?></b></div>
                <div>Stok: <b><?php echo e($product->stock); ?></b></div>
            </div>

            <div class="flex gap-2">
                <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>"
                   class="px-3 py-1 bg-yellow-400 text-sm rounded">
                    Edit
                </a>

                <form action="<?php echo e(route('admin.products.destroy', $product->id)); ?>"
                      method="POST"
                      onsubmit="return confirm('Yakin hapus produk?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="px-3 py-1 bg-red-600 text-white text-sm rounded">
                        Hapus
                    </button>
                </form>
            </div>
        </div>

    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\uas-terbaru\resources\views/admin/products/index.blade.php ENDPATH**/ ?>