<!DOCTYPE html>
<html>
<head>
    <title>Login</title>
    <style>
        body { font-family: 'Arial', sans-serif; background-color: #f4f4f4; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .container { background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 4px 10px rgba(0,0,0,0.1); border-top: 5px solid #800000; width: 300px; text-align: center; }
        h2 { color: #800000; margin-bottom: 20px; }
        input { width: 100%; padding: 10px; margin: 10px 0; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        button { width: 100%; padding: 10px; background-color: #800000; color: white; border: none; border-radius: 4px; cursor: pointer; font-weight: bold; }
        button:hover { background-color: #600000; }
        a { color: #800000; text-decoration: none; font-size: 14px; display: block; margin-top: 15px; }
        .success { color: #155724; background: #d4edda; padding: 10px; border-radius: 4px; font-size: 13px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Login</h2>
        <?php if(session('success')): ?>
            <p class="success"><?php echo e(session('success')); ?></p>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <p class="success" style="background:#f8d7da;color:#721c24;">
                <?php echo e($errors->first()); ?>

            </p>
        <?php endif; ?>

        <form method="POST" action="/login">
            <?php echo csrf_field(); ?>
            <input type="email" name="email" placeholder="Email">
            <input type="password" name="password" placeholder="Password">
            <button type="submit">Login</button>
        </form>
        <a href="/register">Belum punya akun? Register</a>
    </div>
</body>
</html><?php /**PATH C:\laragon\www\uas-terbaru\resources\views/auth/login.blade.php ENDPATH**/ ?>